# -*- coding: utf-8 -*-

'''
**Exercice 5 - Détermination de la valeur d'une capacité**

1. Calculer C = τ/R pour toutes les données. En déduire une valeur moyenne de C ainsi que son incertitude-type. 
2. Conclure sur la compatibilité entre la mesure et la valeur affichée sur le condensateur.

'''
import numpy as np # Numpy permet de faire des calculs simples sur des arrays
import matplotlib.pyplot as plt # Matplotlib pour tracer des graphes

# Enregistrement des données
R = np.array([ 100,200,300,400,500,600,700,800,900,1000])
tau = np.array([151,240,356,458,547,651,741,843,949,1041])*1e-6

# Calcul de C par traitement statistique
C = tau/R

Cmoy = np.mean(C)

nbpoint = len(C)
uC = np.std(C,ddof=1)/np.sqrt(nbpoint)

print("Par la méthode statistique, on mesure C = {:.2e} ± {:.2e} F".format(Cmoy,uC))

En = (abs(Cmoy-1e-6)/uC)


print("Ecart normalisé après traitement statistique avec la valeur attendue : {:.2f}".format(En))
"Question 3"
plt.axis([0,1100,0,1200e-6])
plt.plot(R,tau,'ro')
plt.ylabel(r'$\tau$ (s)')
plt.xlabel(r'R ($\Omega$)')
plt.title("Tracé de tau en fonction de R")
plt.grid()
plt.show()


"Question 4 - REGRESSION LINEAIRE A L'AIDE D'UNE SIMULATION MONTE CARLO"

# Valeurs d'incertitudes-type données dans l'énoncé
u_R = 0.02*R
u_tau = 0.04*tau

# Cacul de la valeur mesurée par régression unique

pente_moy,ordonnee_moy = np.polyfit(R,tau,1)

# Estimation de l'incertitude par monte carlo

N = 10000

pente = []
ordonnee = []

for i in range(0,N):
    l = len(R) 
    mx= R + u_R*np.sqrt(3)*np.random.uniform(-1,1,l) #Attention, comme précisé dans le cours, lorsque la distribution n'est pas précisée, on suppose toujours une distribution uniforme comprise entre plus ou moins Delta avec Delta = sqrt(3)*u
    my= tau + u_tau*np.sqrt(3)*np.random.uniform(-1,1,l)
    p=np.polyfit(mx,my,1)
    pente.append(p[0])
    ordonnee.append(p[1])

u_pente = np.std(pente,ddof=1)
u_ordonnee = np.std(ordonnee,ddof=1)

# Possibilité de changer les labels des axes
plt.ylabel(r'$\tau$ (s)')
plt.xlabel(r'R ($\Omega$)')

xfit = np.linspace(0,1100,2)

plt.axis([0,1100,0,1200e-6])
plt.plot(xfit, ordonnee_moy + pente_moy*xfit, 'r', label='Régression linéaire')
plt.errorbar(R,tau,xerr=u_R,yerr=u_tau,fmt='bo',zorder=2,label='Mesures') #Attention à bien tracer les incertitudes-types
plt.legend()
plt.title("Tracé de tau en fonction de R")
plt.grid()
plt.show()

# Remarque : la droite de tendance ne passe pas par les barres d'incertitudes, ce n'est pas un problème car ces barres représentent l'incertitude-type et donc la variabilité typique de la mesure. Des points séparés de un ou deux incertitudes-types sont accepbtales.



print("Pente {:.2e} ± {:.2e} F".format(pente_moy,u_pente))
print("Ordonnée à l'orgine  {:.2e} ± {:.2e} s".format(ordonnee_moy,u_ordonnee))

"Question 5"

En2 = (abs(pente_moy-1e-6)/u_pente)
print("Ecart normalisé après régression linéaire avec la valeur attendue : {:.2f}".format(En2))

R0 = ordonnee_moy/pente_moy 
u_R0 = np.sqrt((u_pente/pente_moy)**2+(u_ordonnee/ordonnee_moy)**2)*R0

print("Résistance supplémentaire dans le circuit : {:.2e} ± {:.2e} Ω ".format(R0,u_R0))
